/*
 * Decompiled with CFR 0.152.
 */
package org.cloudwarp.mobscarecrow.goals;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3532;
import org.cloudwarp.mobscarecrow.MobScarecrow;
import org.cloudwarp.mobscarecrow.entities.SmallPlushieEntity;
import org.cloudwarp.mobscarecrow.utils.ScarecrowAccess;

public class SeekScarecrowGoal
extends class_1352 {
    private class_1314 mob;
    private Optional<class_1309> target;
    private static final int MIN_WAITING_TIME = 1200;
    private static final int MAX_TRYING_TIME = 1200;
    private static final int MIN_INTERVAL = 200;
    public final double speed;
    protected int cooldown;
    protected int tryingTime;
    private int safeWaitingTime;
    protected class_2338 targetPos = class_2338.field_10980;
    private boolean reached;
    private final int range = 24;
    private final int maxYDifference = 5;
    protected int lowestY = 0;

    public SeekScarecrowGoal(class_1309 mob) {
        this.mob = !(mob instanceof class_1314) ? null : (class_1314)mob;
        this.speed = 1.0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
    }

    public boolean method_6266() {
        return this.tryingTime >= -this.safeWaitingTime && this.tryingTime <= 1200 && this.target.isPresent();
    }

    public boolean method_6264() {
        if (this.mob == null) {
            return false;
        }
        this.checkForScarecrow();
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = this.getInterval(this.mob);
        if (this.target.isEmpty()) {
            return false;
        }
        this.targetPos = this.target.get().method_24515();
        return true;
    }

    protected int getInterval(class_1314 mob) {
        return class_1367.method_38848((int)(200 + mob.method_6051().nextInt(200)));
    }

    private void checkForScarecrow() {
        this.target = Optional.empty();
        Iterator<SmallPlushieEntity> i = ((ScarecrowAccess)this.mob).getAttractiveScarecrows().iterator();
        while (i.hasNext()) {
            SmallPlushieEntity scarecrow = i.next();
            double dist = scarecrow.method_24515().method_19770((class_2374)this.mob.method_19538());
            if (dist > class_3532.method_33723((double)(MobScarecrow.mobScarecrowRadius + 8.0)) || scarecrow.method_31481()) {
                i.remove();
                continue;
            }
            if (!this.target.isEmpty() && !(dist < this.target.get().method_24515().method_19770((class_2374)this.mob.method_19538())) || !(dist < class_3532.method_33723((double)MobScarecrow.mobScarecrowRadius))) continue;
            this.target = Optional.of(scarecrow);
        }
    }

    public void method_6269() {
        this.startMovingToTarget();
        this.tryingTime = 0;
        this.safeWaitingTime = this.mob.method_6051().nextInt(this.mob.method_6051().nextInt(1200) + 1200) + 1200;
    }

    protected void startMovingToTarget() {
        this.mob.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)(this.targetPos.method_10264() + 1), (double)this.targetPos.method_10260() + 0.5, this.speed);
    }

    public double getDesiredDistanceToTarget() {
        return 1.0;
    }

    protected class_2338 getTargetPos() {
        return this.targetPos.method_10084();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_2338 blockPos = this.getTargetPos();
        if (!blockPos.method_19769((class_2374)this.mob.method_19538(), this.getDesiredDistanceToTarget())) {
            this.reached = false;
            ++this.tryingTime;
            if (this.shouldResetPath()) {
                this.mob.method_5942().method_6337((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, this.speed);
            }
        } else {
            this.reached = true;
            --this.tryingTime;
        }
    }

    public boolean shouldResetPath() {
        return this.tryingTime % 40 == 0;
    }

    protected boolean hasReached() {
        return this.reached;
    }
}

